<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Elementor lawfinity-testimonial-slider Widget.
 *
 * Elementor widget that uses the lawfinity-testimonial-slider control.
 *
 * @since 1.0.0
 */
class Elementor_Lawfinity_Testimonial_Slider_Widget extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve lawfinity-testimonial-slider widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'lawfinity-testimonial-slider';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve lawfinity-testimonial-slider widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Lawfinity Testimonial Slider', 'elementor-lawfinity-testimonial-slider-control' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve lawfinity-testimonial-slider widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-carousel-loop';
	}

	/**
	 * Register lawfinity-testimonial-slider widget controls.
	 *
	 * Add input fields to allow the user to customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'Content', 'elementor-lawfinity-testimonial-slider-control' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'selected_style',
			[
				'label' => esc_html__( 'Select Style', 'elementor-lawfinity-testimonial-slider-control' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'style1', // Set the default style
				'options' => [
					'style1' => esc_html__( 'Style 1', 'elementor-lawfinity-testimonial-slider-control' ),
					'style2' => esc_html__( 'Style 2', 'elementor-lawfinity-testimonial-slider-control' ),
					'style3' => esc_html__( 'Style 3', 'elementor-lawfinity-testimonial-slider-control' ),
				],
			]
		);	
		$repeater = new \Elementor\Repeater();
		$repeater->add_control(
			'list_content', [
				'label' => __( 'Content', 'elementor-lawfinity-testimonial-slider-control' ),
				'type' => \Elementor\Controls_Manager::WYSIWYG,
				'default' => __( 'List Content' , 'elementor-lawfinity-testimonial-slider-control' ),
				'label_block' => true,
				'show_label' => false,
			]
		);
		$repeater->add_control(
			'list_image',
			[
				'label' => esc_html__( 'Image', 'elementor-lawfinity-testimonial-slider-control' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'label_block' => true,
				'default' => [
					'url' => PLUGIN_BASE_URI. 'assets/images/testimonial-default-img.png' ,
				],
			]
		);
		$repeater->add_control(
			'list_name', [
				'label' => __( 'Name', 'elementor-lawfinity-testimonial-slider-control' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'Name' , 'elementor-lawfinity-testimonial-slider-control' ),
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'list_designation', [
				'label' => __( 'Designation', 'elementor-lawfinity-testimonial-slider-control' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'Designation' , 'elementor-lawfinity-testimonial-slider-control' ),
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'list_image1',
			[
				'label' => esc_html__( 'Quote Image', 'elementor-lawfinity-testimonial-slider-control' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'label_block' => true,
				'default' => [
					'url' => PLUGIN_BASE_URI. 'assets/images/testimonial-default-img.png' ,
				],
			]
		);
		$this->add_control(
			'list',
			[
				'label' => __( 'Testimonial List', 'elementor-lawfinity-testimonial-slider-control' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'list_content' => __( 'Content', 'elementor-lawfinity-testimonial-slider-control' ),
						'list_image' => __( 'Image', 'elementor-lawfinity-testimonial-slider-control' ),
						'list_name' => __( 'Name', 'elementor-lawfinity-testimonial-slider-control' ),
						'list_designation' => __( 'Designation', 'elementor-lawfinity-testimonial-slider-control' ),
					],
					[
						'list_content' => __( 'Content', 'elementor-lawfinity-testimonial-slider-control' ),
						'list_image' => __( 'Image', 'elementor-lawfinity-testimonial-slider-control' ),
						'list_name' => __( 'Name', 'elementor-lawfinity-testimonial-slider-control' ),
						'list_designation' => __( 'Designation', 'elementor-lawfinity-testimonial-slider-control' ),
					],
				],
			]
		);
	}


	/**
	 * Render lawfinity-testimonial-slider widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		$selected_style = $settings['selected_style'];
		if ($selected_style === 'style1') {
			?>
			<section class="testimonial-con position-relative">
    			<div class="owl-carousel owl-theme" data-aos="fade-up">
					<?php
					if ($settings['list']) {
						foreach ($settings['list'] as $item) {
							?>
							<div class="item">
								<div class="testimonial_content">
									<p class="text-size-18">”<?php echo $item['list_content']; ?>”</p>
									<div class="review-content">
										<figure class="testimonial-personimage mb-0">
											<?php echo wp_get_attachment_image($item['list_image']['id'], 'full'); ?>
										</figure>
										<div class="detail">
											<span class="name"><?php echo $item['list_name'] ?></span>
											<span class="position"><?php echo $item['list_designation'] ?></span>
											<figure class="testimonial-starimage mb-0">
												<img class="img-fluid" src="<?php echo PLUGIN_BASE_URI. 'assets/images/stars-img.png' ?>" alt="">
											</figure>
										</div>
									</div>
								</div>
							</div>
							<?php
						}
					}
					?>
				</div>
			</section>
	
			<?php
		} elseif ($selected_style === 'style2') {
			?>
			<section class="legal_situation_testimonial position-relative">
				<div class="container">
					<div class="row position-relative" data-aos="fade-up">
						<div class="col-12">
							<div id="testimonialcarousel" class="carousel slide" data-ride="carousel">
								<ul class="carousel-indicators">
									<?php
									$count = 0;
									if ( $settings['list'] ) {
										foreach ( $settings['list'] as $item ) {	
									?>
									<li data-target="#testimonialcarousel" data-slide-to="<?=$count?>" class="<?php if($count==0){echo 'active';} ?>">
										<figure class="mb-0">
											<?php echo wp_get_attachment_image($item['list_image']['id'], 'full'); ?>
										</figure>
									</li>
									<?php
									$count++;
										}
									}
									?>
								</ul>
								<div class="carousel-inner">
									<?php
											$count = 0;
											if ( $settings['list'] ) {
											foreach ( $settings['list'] as $item ) {	
										?>
									<div class="carousel-item <?php if($count==0){echo 'active';}?>">
										<div class="testimonial_box">
											<figure class="testimonial-starimage">
												<img src="<?php echo PLUGIN_BASE_URI. 'assets/images/stars-img.png' ?>" alt="image" class="img-fluid">
											</figure>
											<p class="text-size-18">“<?php echo $item['list_content']; ?>”
											</p>
											<div class="name_wrapper">
												<span class="name"><?php echo $item['list_name'] ?></span>
												<span class="position"><?php echo $item['list_designation'] ?></span>
											</div>
										</div>
									</div>
									<?php
											$count++;
										}
										}
										?>
								</div>
								<div class="pagination-outer">
								<a class="carousel-control-prev" href="#testimonialcarousel" role="button" data-slide="prev">
									<i class="fa-solid fa-arrow-left"></i>
									<!-- <span class="sr-only">Previous</span> -->
								</a>
								<a class="carousel-control-next" href="#testimonialcarousel" role="button" data-slide="next">
									<i class="fa-solid fa-arrow-right"></i>
									<!-- <span class="sr-only">Next</span> -->
								</a>
							</div>
							</div>
						</div>
					</div>
				</div>
			</section>
			<?php
		} elseif ($selected_style === 'style3') {
			?>
			<section class="faq_testimonial-con aboutpage-testimonial position-relative">
				<div class="container">
					<div class="row position-relative" data-aos="fade-up">
						<div class="testimonial_content">
						<figure class="testimonial-quote">
							<img class="img-fluid" src="<?php echo PLUGIN_BASE_URI. 'assets/images/faq-testimonialquote.png' ?>" alt="">
						</figure>
							<div class="owl-carousel owl-theme">
						<?php
						if ($settings['list']) {
							foreach ($settings['list'] as $item) {
								?>
								<div class="item">
									<div class="content-box">
										<figure class="testimonial-starimage">
											<img class="img-fluid" src="<?php echo PLUGIN_BASE_URI. 'assets/images/stars-img.png' ?>" alt="">
										</figure>
										<p class="text-size-18">“<?php echo strip_tags($item['list_content']) ?>”
										</p>
										<div class="review-content">
											<figure class="testimonial-personimage mb-0">
												<?php echo wp_get_attachment_image($item['list_image']['id'], 'full'); ?>
											</figure>
											<div class="detail">
												<span class="name"><?php echo $item['list_name'] ?></span>
												<span class="position"><?php echo $item['list_designation'] ?></span>
											</div>
										</div>
									</div>
								</div>
								<?php
							}
						}
						?>
							</div>
						</div>
					</div>
				</div>
			</section>
			<?php
		}
	}
	
}